# Age_structure.R
# Tests of independence - age structure data

# Load necessary libraries
library(ggplot2)
library(gmodels)

# Read in data set
agedata <- read.table(header=T,colClasses=c("factor","factor","numeric"),text="
pop age obsfreq
1  0  36
1  1  22
1  2  18
1  3  13
1  4  11
2  0  48
2  1  24
2  2  14
2  3  10
2  4   4
3  0  60
3  1  21
3  2  12
3  3   5
3  4   2
")

# Print data
agedata

# Convert tabulated data to raw form for CrossTable
pop <- rep(agedata[,"pop"],agedata$obsfreq)
age <- rep(agedata[,"age"],agedata$obsfreq)

# Tests of independence
CrossTable(age,pop,expected=TRUE)

# Generate bar chart showing proportions
ggplot(agedata,aes(pop,fill=age))+
geom_bar(position="fill",aes(weight=obsfreq))+
scale_fill_grey(start=0,end=1)

